unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function EnumNamesFunc(hModule : THandle; lptype,lpName : PChar; Form : TForm1) : Bool; stdcall;
var
  ResourceStream : TResourceStream;
  OutStream, FinalStream : TMemoryStream;
  Buffer : Array[0..10] of Byte;
  Tamanho : Integer;
begin
  if (Cardinal(lpName) and $FFFF0000) <> 0 then begin
// cria ResourceStream com recurso encontrado
    ResourceStream := TResourceStream.Create(hInstance,lpName,RT_RCDATA);
    try
      OutStream := TMemoryStream.Create;
      FinalStream := TMemoryStream.Create;
      try
        try
          Buffer[0] := $FF;
          Buffer[1] := $0A;
          Buffer[2] := $00;
// grava $FF0A00 no stream intermedirio
          OutStream.Write(Buffer,3);
// grava o nome do recurso no stream
          OutStream.Write(lpName^,StrLen(lpName)+1);
          Buffer[0] := $30;
          Buffer[1] := $10;
// grava as opes de recurso
          OutStream.Write(Buffer,2);
          Tamanho := ResourceStream.Size;
// grava o tamanho no stream
          OutStream.Write(Tamanho,Sizeof(Integer));
// adiciona o stream ao final
          OutStream.Write(ResourceStream.Memory^,ResourceStream.Size);
          OutStream.Seek(0,soFromBeginning);
// tenta converter
          ObjectResourceToText(OutStream,FinalStream);
// converteu - salva em arquivo
          FinalStream.SaveToFile(String(lpName)+'.txt');
        except
// no converteu - no faz nada
          On EReadError do
            ;
        end;
      finally
        OutStream.Free;
        FinalStream.Free;
      end;
    finally
      ResourceStream.Free;
    end;
  end;
  Result := True;
end;

function EnumResFunc(hModule : THandle; lpszType : PChar; Form : TForm1) : Bool ; stdcall;
begin
// testa para ver se tipo = RT_RCDATA
  if ((Cardinal(lpszType) and $FFFF0000) = 0) and (lpszType = RT_RCDATA) then begin
// chama funo de enumerao
    EnumResourceNames(hModule,MakeIntResource(RT_RCDATA),@EnumNamesFunc,LongInt(Form));
// pra com enumerao
    Result := False;
  end
  else
    Result := True;
end;


procedure TForm1.Button1Click(Sender: TObject);
var
  HInst : THandle;
begin
  with OpenDialog1 do
    if Execute then begin
// abre o executvel
      HInst := LoadLibraryEx(PChar(FileName),0,LOAD_LIBRARY_AS_DATAFILE);
      if HInst > 0 then begin
// chama a enumerao de tipos de recursos
        EnumResourceTypes(HInst,@EnumResFunc,LongInt(Self));
// libera o executvel
        FreeLibrary(HInst);
      end;
    end;
end;

end.
